/*
 * Decompiled with CFR 0.152.
 */
package com.chailotl.sushi_bar.lavender;

import io.wispforest.lavender.md.compiler.BookCompiler;
import io.wispforest.lavender.md.features.RecipeFeature;
import io.wispforest.lavendermd.Lexer;
import io.wispforest.lavendermd.MarkdownFeature;
import io.wispforest.lavendermd.Parser;
import io.wispforest.lavendermd.compiler.MarkdownCompiler;
import io.wispforest.lavendermd.compiler.OwoUICompiler;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.ItemComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.parsing.UIModelLoader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1860;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Recipe2x2Feature
implements MarkdownFeature {
    private final BookCompiler.ComponentSource bookComponentSource;
    private final Map<class_3956<?>, RecipeFeature.RecipePreviewBuilder<?>> previewBuilders;
    public static final RecipeFeature.RecipePreviewBuilder<class_3955> CRAFTING_2X2_PREVIEW_BUILDER = new RecipeFeature.RecipePreviewBuilder<class_3955>(){

        @NotNull
        public Component buildRecipePreview(BookCompiler.ComponentSource componentSource, class_3955 recipe) {
            ParentComponent recipeComponent = (ParentComponent)componentSource.template(UIModelLoader.get((class_2960)new class_2960("sushi_bar:book_components")), ParentComponent.class, "crafting-2x2-recipe");
            this.populateIngredientsGrid((class_1860)recipe, (List)recipe.method_8117(), (ParentComponent)recipeComponent.childById(ParentComponent.class, "input-grid"), 2, 2);
            ((ItemComponent)recipeComponent.childById(ItemComponent.class, "output")).stack(recipe.method_8110(class_310.method_1551().field_1687.method_30349()));
            return recipeComponent;
        }
    };

    public Recipe2x2Feature(BookCompiler.ComponentSource bookComponentSource, @Nullable Map<class_3956<?>, RecipeFeature.RecipePreviewBuilder<?>> previewBuilders) {
        this.bookComponentSource = bookComponentSource;
        this.previewBuilders = new HashMap(previewBuilders != null ? previewBuilders : Map.of());
        this.previewBuilders.putIfAbsent(class_3956.field_17545, CRAFTING_2X2_PREVIEW_BUILDER);
    }

    public String name() {
        return "2x2_recipes";
    }

    public boolean supportsCompiler(MarkdownCompiler<?> compiler) {
        return compiler instanceof OwoUICompiler;
    }

    public void registerTokens(MarkdownFeature.TokenRegistrar registrar) {
        registrar.registerToken((nibbler, tokens) -> {
            if (!nibbler.tryConsume("<recipe_2x2;")) {
                return false;
            }
            String recipeIdString = nibbler.consumeUntil('>');
            if (recipeIdString == null) {
                return false;
            }
            class_2960 recipeId = class_2960.method_12829((String)recipeIdString);
            if (recipeId == null) {
                return false;
            }
            Optional recipe = class_310.method_1551().field_1687.method_8433().method_8130(recipeId);
            if (recipe.isEmpty()) {
                return false;
            }
            tokens.add(new RecipeToken(recipeIdString, (class_1860)recipe.get()));
            return true;
        }, '<');
    }

    public void registerNodes(MarkdownFeature.NodeRegistrar registrar) {
        registrar.registerNode((parser, recipeToken, tokens) -> new RecipeNode(recipeToken.recipe), (token, tokens) -> {
            RecipeToken recipe;
            return token instanceof RecipeToken ? (recipe = (RecipeToken)((Object)token)) : null;
        });
    }

    private static class RecipeToken
    extends Lexer.Token {
        public final class_1860<?> recipe;

        public RecipeToken(String content, class_1860<?> recipe) {
            super(content);
            this.recipe = recipe;
        }
    }

    private class RecipeNode
    extends Parser.Node {
        private final class_1860<?> recipe;

        public RecipeNode(class_1860<?> recipe) {
            this.recipe = recipe;
        }

        protected void visitStart(MarkdownCompiler<?> compiler) {
            RecipeFeature.RecipePreviewBuilder<?> previewBuilder = Recipe2x2Feature.this.previewBuilders.get(this.recipe.method_17716());
            if (previewBuilder != null) {
                ((OwoUICompiler)compiler).visitComponent(previewBuilder.buildRecipePreview(Recipe2x2Feature.this.bookComponentSource, this.recipe));
            } else {
                ((OwoUICompiler)compiler).visitComponent((Component)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).child(Components.label((class_2561)class_2561.method_43470((String)("No preview builder registered for recipe type '" + class_7923.field_41188.method_10221((Object)this.recipe.method_17716()) + "'"))).horizontalSizing(Sizing.fill((int)100))).padding(Insets.of((int)10)).surface(Surface.flat((int)0x77A00000).and(Surface.outline((int)0x77FF0000))));
            }
        }

        protected void visitEnd(MarkdownCompiler<?> compiler) {
        }
    }
}

